package jcircus.visitor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

import jcircus.environment.Environment;
import jcircus.environment.ProcChanEnv;
import jcircus.environment.NameTypeEnv;
import jcircus.exceptions.ChanDefOtherChanSyncException;
import jcircus.exceptions.ChanDefOtherChanUseException;
import jcircus.exceptions.ChanSyncUnificationException;
import jcircus.exceptions.ChanUseUnificationException;
import jcircus.exceptions.DifferentCardinalitiesException;
import jcircus.exceptions.InvalidFormatCommException;
import jcircus.exceptions.InvalidParameterException;
import jcircus.exceptions.InvalidSubTypeException;
import jcircus.exceptions.MoreThanOneWriterException;
import jcircus.exceptions.UnrecoveredErrorException;
import jcircus.exceptions.VisitingMethodNotDefinedException;
import jcircus.exceptions.JCircusException;
import jcircus.util.CircusType;
import jcircus.util.Constants;
import jcircus.util.Error;
import jcircus.util.ErrorMessage;
import jcircus.util.IdCircusProcessGenerator;
import jcircus.util.ChanUse;
import jcircus.util.MathToolkitConstants;
import jcircus.util.NameType;
import jcircus.util.ChanSync;
import jcircus.util.Util;
import jcircus.util.annotations.IdCircusProcessAnn;
import net.sourceforge.czt.base.ast.ListTerm;
import net.sourceforge.czt.base.ast.Term;
import net.sourceforge.czt.circus.ast.Action1;
import net.sourceforge.czt.circus.ast.Action2;
import net.sourceforge.czt.circus.ast.ActionD;
import net.sourceforge.czt.circus.ast.ActionIte;
import net.sourceforge.czt.circus.ast.ActionPara;
import net.sourceforge.czt.circus.ast.AssignmentCommand;
import net.sourceforge.czt.circus.ast.AssignmentPair;
import net.sourceforge.czt.circus.ast.BasicAction;
import net.sourceforge.czt.circus.ast.BasicChannelSet;
import net.sourceforge.czt.circus.ast.BasicProcess;
import net.sourceforge.czt.circus.ast.CallAction;
import net.sourceforge.czt.circus.ast.CallProcess;
import net.sourceforge.czt.circus.ast.CallType;
import net.sourceforge.czt.circus.ast.ChannelDecl;
import net.sourceforge.czt.circus.ast.ChannelPara;
import net.sourceforge.czt.circus.ast.ChannelSet;
import net.sourceforge.czt.circus.ast.ChannelSetPara;
import net.sourceforge.czt.circus.ast.CircusAction;
import net.sourceforge.czt.circus.ast.CircusProcess;
import net.sourceforge.czt.circus.ast.CommType;
import net.sourceforge.czt.circus.ast.Communication;
import net.sourceforge.czt.circus.ast.DotField;
import net.sourceforge.czt.circus.ast.ExtChoiceAction;
import net.sourceforge.czt.circus.ast.Field;
import net.sourceforge.czt.circus.ast.GuardedAction;
import net.sourceforge.czt.circus.ast.HideAction;
import net.sourceforge.czt.circus.ast.HideProcess;
import net.sourceforge.czt.circus.ast.IfGuardedCommand;
import net.sourceforge.czt.circus.ast.InputField;
import net.sourceforge.czt.circus.ast.MuAction;
import net.sourceforge.czt.circus.ast.NameSetPara;
import net.sourceforge.czt.circus.ast.OutputField;
import net.sourceforge.czt.circus.ast.ParAction;
import net.sourceforge.czt.circus.ast.ParProcess;
import net.sourceforge.czt.circus.ast.ParamAction;
import net.sourceforge.czt.circus.ast.ParamProcess;
import net.sourceforge.czt.circus.ast.PrefixingAction;
import net.sourceforge.czt.circus.ast.Process1;
import net.sourceforge.czt.circus.ast.Process2;
import net.sourceforge.czt.circus.ast.ProcessD;
import net.sourceforge.czt.circus.ast.ProcessIdx;
import net.sourceforge.czt.circus.ast.ProcessIte;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.circus.ast.RefChannelSet;
import net.sourceforge.czt.circus.ast.RenameProcess;
import net.sourceforge.czt.circus.ast.SchExprAction;
import net.sourceforge.czt.circus.ast.VarDeclCommand;
import net.sourceforge.czt.z.ast.ApplExpr;
import net.sourceforge.czt.z.ast.AxPara;
import net.sourceforge.czt.z.ast.BindExpr;
import net.sourceforge.czt.z.ast.Box;
import net.sourceforge.czt.z.ast.Branch;
import net.sourceforge.czt.z.ast.CondExpr;
import net.sourceforge.czt.z.ast.ConstDecl;
import net.sourceforge.czt.z.ast.Decl;
import net.sourceforge.czt.z.ast.DeclName;
import net.sourceforge.czt.z.ast.Expr;
import net.sourceforge.czt.z.ast.Expr0N;
import net.sourceforge.czt.z.ast.Expr1;
import net.sourceforge.czt.z.ast.Expr2;
import net.sourceforge.czt.z.ast.ExprPred;
import net.sourceforge.czt.z.ast.Fact;
import net.sourceforge.czt.z.ast.FreePara;
import net.sourceforge.czt.z.ast.Freetype;
import net.sourceforge.czt.z.ast.MemPred;
import net.sourceforge.czt.z.ast.NameExprPair;
import net.sourceforge.czt.z.ast.NegPred;
import net.sourceforge.czt.z.ast.NumExpr;
import net.sourceforge.czt.z.ast.Para;
import net.sourceforge.czt.z.ast.Pred;
import net.sourceforge.czt.z.ast.Pred2;
import net.sourceforge.czt.z.ast.RefExpr;
import net.sourceforge.czt.z.ast.RefName;
import net.sourceforge.czt.z.ast.SchExpr;
import net.sourceforge.czt.z.ast.SchText;
import net.sourceforge.czt.z.ast.Spec;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.ZSect;
import net.sourceforge.czt.z.impl.ZFactoryImpl;
import net.sourceforge.czt.z.impl.ZSectImpl;
import net.sourceforge.czt.z.util.Factory;
import circparser.formw.action.Action;
import jcircus.util.SignatureExpression;
import net.sourceforge.czt.base.impl.ListTermImpl;
import net.sourceforge.czt.z.ast.NameTypePair;
import net.sourceforge.czt.z.ast.Signature;

/**
 * EnvLoadingVisitor.java
 * 
 * Performs the pre-processing of the Circus specification.
 *
 * @author Angela Freitas
 *
 */
public class EnvLoadingVisitor implements EnvLoadingVisitorInterface {
    
    private DeclName currentProcess_ = null;

    private DeclName currentAction_ = null;

    private String stateName_ = null;    
    
    // Environment for channels and types.
    private Environment environment_;
    
    // Flag that indicates an external choice.
    private boolean externalChoice_ = false;
    
    private String currentRecursiveAction_;
    
    private Factory factory_;
    
    private boolean globalScope_;
    
    private List<Error> errors_;

    public List<Error> getErrors() {
        return this.errors_;
    }
    
    /**
     * Methods to report errors.
     */
    
    private void reportError(Error error) {
        errors_.add(error);
    }
    
    private void reportFatalError(Error error) throws UnrecoveredErrorException {
        reportError(error);
        throw new UnrecoveredErrorException("Error during the environment loading.");
    }

    private void reportFatalError(Error error, Exception e) throws UnrecoveredErrorException {
        reportError(error);
        throw new UnrecoveredErrorException("Error during the environment loading.", e);
    }
    
    /**
     * Constructor for class EnvLoadingVisitor.
     *
     * @param Environment
     */
    public EnvLoadingVisitor(Environment Environment) {
        this.environment_ = Environment;
        this.factory_ = new Factory();
        this.globalScope_ = true;
        this.stateName_ = null;
        this.loadMathToolkit();
        this.errors_ = new ArrayList();
    }
    
    /**
     * Just in case this visitor is called for a node that has not been considered yet.
     *
     * @param term
     * @return
     */
    public Object visitTerm(Term term) {
        
        throw new VisitingMethodNotDefinedException(term.getClass(), this.getClass());
    }
    
    /** **************************************************************************************************************
     * Term A Tree.
     * ***************************************************************************************************************
     */
    
    /**
     * 
     */
    public Object visitSpec(Spec spec) { 
        
        ZSect zSect = (ZSect) spec.getSect().get(0);
        ListTerm paras = zSect.getPara();
        
        Para para;
        
        for (int i = 0; i < paras.size(); i++) {
            
            para = (Para) paras.get(i);
            para.accept(this);
        }
        
        return null;
    }
    
    /**
     *
     */
    public Object visitFreetype(Freetype freetype) {
        
        ListTerm branches = freetype.getBranch();
        DeclName declNameFreetype = freetype.getDeclName();
        
        Branch branch;
        
        // Add this freeType to the freeTypeEnvironment
        this.environment_.freeTypesEnvironmentAdd(freetype);
        
        // Declare the free type in the TypeEnvironment
        CircusType circusType = new CircusType(factory_.createPowerExpr(
                factory_.createRefExpr(factory_.createRefName(declNameFreetype.toString()))));

        //Util.createCircusType(this.factory_.createPowerExpr(), this.environment_);
        this.environment_.declareName(
                this.factory_.createDeclName(declNameFreetype.toString()), 
                NameType.FreeType, 
                circusType);
        
        for (int i = 0; i < branches.size(); i++) {
            
            branch = (Branch) branches.get(i);
            
            DeclName declNameBranch = branch.getDeclName();
            Expr expr = branch.getExpr();
            Expr type;
            RefExpr refExprNameFreeType = this.factory_.createRefExpr(
                    this.factory_.createRefName(declNameFreetype));
            
            if (expr != null) {
                List list = new ArrayList();
                list.add(expr);
                list.add(declNameFreetype);
                type = this.factory_.createPowerExpr(
                        this.factory_.createProdExpr(expr, refExprNameFreeType));
                //new PowerSet(new CartesianProduct(list));
            } else {
                // RefExpr
                type = refExprNameFreeType;
            }
            
            // Only the first element will the its type 
            // (the free type) added to the type list
            boolean b = (i == 0) ? true : false;
            
            // Declare the branch of the free type in the TypeEnvironment
            this.environment_.declareName(
                    this.factory_.createDeclName(declNameBranch.toString()),
                    NameType.ElemFreeType, new CircusType(type), b);
        }
        
        return null;
    }
    
    /**
     * Visits a schema text and returns its signature.
     *
     */
    public Object visitSchText(SchText schText) {
        
        Signature result = this.factory_.createSignature(Util.createEmptyList());
        
        ListTerm decls = schText.getDecl();
        Pred pred = schText.getPred();
        Signature signature;
        ListTerm nameTypePairs;
        Decl decl;
        
        // Gets the annotation
        NameType nameType = Util.getAndRemoveNameTypeAnn(schText);
        
        // Open the scope of the schema
        this.environment_.openScope();
        
        if(decls != null) {
            
            for (int i = 0; i < decls.size(); i++) {
                
                /**
                 * If this is a SchText for a schema (NameType == StateComp)
                 *
                 */
                
                decl = (Decl) decls.get(i);
                
                // Adds annotation
                Util.addNameTypeAnn(decl, nameType);
                
                // Visits the declaration
                signature = (Signature) decl.accept(this);
                
                // Add to the signature
                result.getNameTypePair().addAll(signature.getNameTypePair());
            }
        }
        
        if (pred != null)
            pred.accept(this);
        
        // Close the scope of the schema
        this.environment_.closeScope();
        
        return result;
    }
    
    /** **************************************************************************************************************
     * Decl Tree.
     * ***************************************************************************************************************
     */
    
    /**
     * 
     */
    public Object visitChannelDecl(ChannelDecl channelDecl) {
        
        ListTerm genNames = channelDecl.getDeclName();
        Decl decl = channelDecl.getDecl();
        
        CircusType circusType;
        
        if (decl instanceof VarDecl) {
            
            VarDecl varDecl = (VarDecl) decl;
            ListTerm declNames = varDecl.getDeclName();
            Expr expr = varDecl.getExpr();
            
            if (expr != null) {
                
                if (genNames != null && genNames.size() > 0)
                    circusType = new CircusType(genNames, expr);
                else
                    circusType = new CircusType(expr);
                
            } else {
                // Single sync channel
                circusType = CircusType.createSyncType();
            }
            
            for (int i = 0; i < declNames.size(); i++) {
                
                DeclName declName = (DeclName) declNames.get(i);
                this.environment_.declareName(declName, NameType.Channel, circusType);
            }
            
        } else
            // A channel declaration can only be of type VarDecl
            // This must not happen because the parser must not let this pass;
            // it's good to check again here anyway.
            // Note: better to be a invalid format exception
            throw new InvalidSubTypeException(decl.getClass());
        
        return null;
    }

    /**
     * 
     */
    public Object visitVarDecl(VarDecl varDecl) {

        ListTerm declNames = varDecl.getDeclName();
        Expr expr = varDecl.getExpr();
        
        DeclName declName;
        NameTypePair nameTypePair;
  
        // Visits the expression
        expr.accept(this);
        
        // Creates a CircusType
        CircusType circusType = new CircusType(expr);
        
        // Gets the IdType annotation
        NameType nameType = Util.getAndRemoveNameTypeAnn(varDecl);

        // Declares each name in the list
        for (int i = 0; i < declNames.size(); i++) {

            declName = (DeclName) declNames.get(i);

            // Declares in the current scope
            this.environment_.declareName(declName, nameType, circusType);

            // Add the type annotation
            Util.addCircusTypeAnn(declName, circusType);
        }
        
        return null;
    }
    
    /**
     * Returns the signature
     */
    public Object visitConstDecl(ConstDecl constDecl) {

        DeclName declName = constDecl.getDeclName();
        Expr expr = constDecl.getExpr();

        // Visits the expression
        expr.accept(this);

        // Creates a circus type
        CircusType circusType = new CircusType(expr);

        // Gets the IdType annotation
        NameType nameType = Util.getAndRemoveNameTypeAnn(constDecl);
        
        // Declares in the current scope
        circusType = this.environment_.declareName(declName, nameType, circusType);

        // Add the type annotation
        Util.addCircusTypeAnn(declName, circusType);

        return null;
    }
        
    /** **************************************************************************************************************
     * Para Tree.
     * @return  null.
     * ***************************************************************************************************************
     */
    
    /**
     * 
     */
    public Object visitChannelPara(ChannelPara channelPara) {
        
        ListTerm decls = channelPara.getChannelDecl();
        Decl decl;
        
        for (int i = 0; i < decls.size(); i++) {
            decl = (Decl) decls.get(i);
            decl.accept(this);
        }
        
        return null;
    }
    
    /**
     * 
     */
    public Object visitChannelSetPara(ChannelSetPara channelSetPara) {
        
        DeclName declName = channelSetPara.getDeclName();
        ChannelSet channelSet = channelSetPara.getChannelSet();
        
        HashSet hashSet = (HashSet) channelSet.accept(this);
        this.environment_.declareChannelSet(declName.toString(), hashSet);
        
        return null;
    }
    
    /**
     * 
     */
    public Object visitProcessPara(ProcessPara processPara) {
        
        ProcChanEnv procChanEnv;
        
        DeclName declName = processPara.getDeclName();
        CircusProcess circusProcess = processPara.getCircusProcess();
        
        // Sets the name of the current process
        currentProcess_ = declName;
        
        // Here we enter in the scope of a process
        this.globalScope_ = false;

        // Hiding is permitted only here
        if (circusProcess instanceof HideProcess) {
            Util.addHideOkAnn((HideProcess) circusProcess);
        }
        
        // Visits the process
        procChanEnv = (ProcChanEnv) circusProcess.accept(this);

        // Adds the annotation
        Util.addProcChanEnvAnn(processPara, procChanEnv);

        // Adds the annotation
        Util.addChannelMSEnvAnn(processPara, procChanEnv.getChanInfoEnv());

        // TODO: Tirar isto?
        this.environment_.declareProcess(declName.toString(), procChanEnv);

        // Here we return to the global scope
        this.globalScope_ = true;
            
        // Sets the name of the current process to null
        currentProcess_ = null;
        
        return null;
    }
    
    /**
     *
     */
    public Object visitFreePara(FreePara freePara) {
        
        List freeTypes = freePara.getFreetype();
        Freetype freetype;
        
        for (int i = 0; i < freeTypes.size(); i++) {
            
            freetype = (Freetype) freeTypes.get(i);
            freetype.accept(this);
            
        }
        return null;
    }
    
    /**
     * 
     */
    public Object visitActionPara(ActionPara actionPara) {
        
        ProcChanEnv result = null;
        
        DeclName actionName = actionPara.getDeclName();
        CircusAction circusAction = actionPara.getCircusAction();
        
        currentAction_ = actionName;
        
        result = (ProcChanEnv) circusAction.accept(this);
            
        currentAction_ = null;
        
        return result;
    }
    
    public Object visitNameSetPara(NameSetPara NameSetPara) {
        return null;
    }
    
    public Object visitAxPara(AxPara axPara) {
        
        Box box = axPara.getBox();
        ListTerm genParams = axPara.getDeclName(); // not dealing with generics for the moment
        SchText schText = axPara.getSchText();
        
        if (box.equals(Box.AxBox) || box.equals(Box.OmitBox)) {
        
            // Axiomatic or horizontal definition

            NameType nameType;
            if (this.globalScope_) {
                nameType = NameType.GlobalConstant;
            } else {
                nameType = NameType.LocalConstant;
            }
            
            List decls = schText.getDecl();
            Pred pred = schText.getPred();
                    
            environment_.openScope();
            
            for (int i=0; i<decls.size(); i++) {
                Decl decl = (Decl) decls.get(i);
                Util.addNameTypeAnn(decl, nameType);
                decl.accept(this);
            }
            
            if (pred != null)
                pred.accept(this);
            
            Signature signature = null;
                
            signature = environment_.getCurrentScopeAsSig(); 
                
            environment_.closeScope();

            /**
             * Declarations of constants are always brought to outer scope.
             */
            defineSignature(signature, NameType.StateComponent);
            
        } else if (box.equals(Box.SchBox)) {
            
            // Schema definition
            
            DeclName schName = ((ConstDecl) schText.getDecl().get(0)).getDeclName();
            List decls = ((SchExpr) ((ConstDecl) schText.getDecl().get(0)).getExpr()).getSchText().getDecl();
            Pred pred = ((SchExpr) ((ConstDecl) schText.getDecl().get(0)).getExpr()).getSchText().getPred();
                    
            environment_.openScope();
            
            for (int i=0; i<decls.size(); i++) {
                Decl decl = (Decl) decls.get(i);
                Util.addNameTypeAnn(decl, NameType.StateComponent);
                decl.accept(this);
            }
            
            if (pred != null)
                pred.accept(this);
            
            Signature signature = environment_.getCurrentScopeAsSig(); 
                
            environment_.closeScope();

            // Declare name of schema in current scope
            environment_.declareName(schName, NameType.SchemaName, 
                    new CircusType(new SignatureExpression(signature)));
            /**
             * Brings the declarations from the schema only if this schema
             * is used to declare state.
             */
            if (stateName_ != null && stateName_.equals(schName.toString()))
                defineSignature(signature, NameType.StateComponent);
        
        } else {
            // This should not happen because there is no other type of Box
            throw new InvalidParameterException("Box == " + axPara.getBox());
        }
        
        return null;
    }
    
    /** **************************************************************************************************************
     * ChannelSet Tree.
     * @return  HashSet
     * ***************************************************************************************************************
     */
    
    /**
     *
     */
    public Object visitBasicChannelSet(BasicChannelSet basicChannelSet) {
        
        HashSet r = new HashSet();
        List list = basicChannelSet.getRefName();
        for (int i = 0; i < list.size(); i++) {
            r.add(list.get(i).toString());
        }
        
        return r;
    }
    
    /**
     *
     */
	public Object visitRefChannelSet (RefChannelSet refChannelSet) {
 
                HashSet result = null;
                RefName refName = refChannelSet.getRefName();
 
                result = this.environment_.getChannelSet(refName.toString());
                return result;
        }
    
    /** **************************************************************************************************************
     * NameSet Tree.
     * ***************************************************************************************************************
     */
    
    
    /** **************************************************************************************************************
     * CircusProcess Tree.
     * ***************************************************************************************************************
     */
    
    /**
     * The methods of these tree always return a ProcessChannelEnvironment.
     */ 
    
    /**
     * 
     */
    public Object visitBasicProcess(BasicProcess basicProcess) {
        
        ProcChanEnv result = new ProcChanEnv();
        
        RefName stateSchemaRefName = basicProcess.getStateSchema();
        CircusAction mainAction = basicProcess.getMainAction();
        ListTerm actionParas = basicProcess.getCircusActionPara();
        ListTerm nameSetParas = basicProcess.getCircusNameSetPara();
        ListTerm zParas = basicProcess.getZPara();
        
        try {
            // Set global variable
            if (stateSchemaRefName != null)
                stateName_ = stateSchemaRefName.toString();

            ProcChanEnv procChanEnv = null;
            ActionPara actionPara;

            // Visit the zParas
            for (int i = 0; i < zParas.size(); i++) {        

                Para para = (Para) zParas.get(i);
                para.accept(this);
            }

            // Visit the nameSetParas
            for (int i = 0; i < nameSetParas.size(); i++) {        

                NameSetPara nameSetPara = (NameSetPara) nameSetParas.get(i);
                nameSetPara.accept(this);
            }

            if (stateSchemaRefName != null) {

                // This process defines a state

                // Inserts type annotation in the state
                CircusType circusType = this.environment_.getCircusType(stateSchemaRefName.toString());
                Util.addCircusTypeAnn(stateSchemaRefName, circusType);

                // Brings all the declarations in the state to this scope (the type 
                //of the state will always be a signature (schema type))
                Signature signature = ((SignatureExpression) circusType.getExpression()).getSignature();
                this.defineSignature(signature, NameType.StateComponent);
                    
            }

            // Visits the circusActions
            for (int i = 0; i < actionParas.size(); i++) {

                actionPara = (ActionPara) actionParas.get(i);

                CircusAction circusAction = actionPara.getCircusAction();

                // Visits the circus action only if it is not the state
                procChanEnv = (ProcChanEnv) actionPara.accept(this);
                result = result.merge(procChanEnv, false);
            }

            // Visits the main action
            procChanEnv = (ProcChanEnv) mainAction.accept(this);
            result = result.merge(procChanEnv, false);

            // Add id annotation
            int id = IdCircusProcessGenerator.getGenerator().getNextId();
            IdCircusProcessAnn ann = new IdCircusProcessAnn(id);
            Util.addIdCircusProcessAnn(basicProcess, ann);

            // Updates MultiSyncEnv
            result.transform(new Integer (id));
                
            // Set the flag to say that this is a environment for a basic process
            result.setBasicProcess();
        
        } catch (MoreThanOneWriterException e) {
            Object[] params = new Object[] { 
                    currentProcess_, currentAction_ };
            reportFatalError(new Error(ErrorMessage.PAR_WRITERS, params), e);
            
        } catch (ChanUseUnificationException e) {
            Object[] params = new Object[] { 
                    currentProcess_, currentAction_ };
            reportFatalError(new Error(ErrorMessage.CHANUSE_UNIF, params), e);
            
        } catch (DifferentCardinalitiesException e) {
            Object[] params = new Object[] { 
                    currentProcess_, currentAction_ };
            reportFatalError(new Error(ErrorMessage.DIFF_CARD, params), e);
            
        } catch (ChanSyncUnificationException e) {
            Object[] params = new Object[] { 
                    currentProcess_, currentAction_ };
            reportFatalError(new Error(ErrorMessage.CHANSYNC_UNIF, params), e);
        }
            
        // Set global variable
        stateName_  = null;
        
        return result;
    }
    
    /**
     * 
     */
    public Object visitCallProcess(CallProcess callProcess) {
        
        ProcChanEnv result = null;
        
        RefName refName = callProcess.getRefName();
        CallType callType = callProcess.getCallType();
        
        if (callType == CallType.Normal) {
            
            // Gets the environment of the process
            // Is this really necessary? A CallProcess will be translated as another process ...
            result = this.environment_.getProcessChannelEnvironment(refName.toString());
            
        } else if (callType == CallType.Param || callType == CallType.Gen || callType == CallType.Index) {
            
            ListTerm params = callProcess.getExpr();
            Expr expr;
            
            // Visit the parameters
            for (int i = 0; i < params.size(); i++) {
                
                expr = (Expr) params.get(i);
                expr.accept(this);
            }
            
            // Gets the environment of the process
            result = this.environment_.getProcessChannelEnvironment(refName.toString());
            
            
        } else {
            // This should not happen because there is no other type of CallType.
            throw new InvalidParameterException(
                    "Invalid Parameter (" + callType.getClass() + "): " + callType.toString());
        }
        
        // Add id annotation
        IdCircusProcessAnn ann = new IdCircusProcessAnn(IdCircusProcessGenerator.getGenerator().getNextId());
        Util.addIdCircusProcessAnn(callProcess, ann);
        
        if (result.isBasicProcess()) {
            
            // If this is a call to a basic process, I need to substitute the ids
            // of the basic process in ChanSyncEnv by the ids of this callProcess
            
            /** Isto estava errado!
                MultiSyncEnv multiSyncEnv = result.getMultiSyncEnv();
                multiSyncEnv = multiSyncEnv.replaceId(ann.getId());
                result.setMultiSyncEnv(multiSyncEnv);
             */
            result = result.replaceIdInChanInfoEnv(ann.getId());
        
        }
        return result;
    }
    
    /**
     * 
     */
    public Object visitProcess1(Process1 process1) {
        
        ProcChanEnv result;
        
        CircusProcess circusProcess = process1.getCircusProcess();
        
        result = (ProcChanEnv) circusProcess.accept(this);
        
        // Add id annotation
        IdCircusProcessAnn ann = new IdCircusProcessAnn(
                IdCircusProcessGenerator.getGenerator().getNextId());
        Util.addIdCircusProcessAnn(process1, ann);
        
        return result;
    }
    
    /**
     * 
     */
    public Object visitRenameProcess(RenameProcess renameProcess) {
        //
        ProcChanEnv result = null;
        
        CircusProcess circusProcess = renameProcess.getCircusProcess();
        ListTerm oldChannels = renameProcess.getOldNames();
        ListTerm newChannels = renameProcess.getNewNames();
        
        result = (ProcChanEnv) circusProcess.accept(this);

        result = result.substitute(newChannels, oldChannels);

        // Add id annotation
        IdCircusProcessAnn ann = new IdCircusProcessAnn(
                IdCircusProcessGenerator.getGenerator().getNextId());
        Util.addIdCircusProcessAnn(renameProcess, ann);
            
        return result;
    }
    
    /**
     * 
     */
    public Object visitHideProcess(HideProcess hideProcess) { 
        
        ProcChanEnv result = null;
        
        CircusProcess circusProcess = hideProcess.getCircusProcess();
        ChannelSet channelSet = hideProcess.getChannelSet();

        // Check if this hiding is legal
        if (Util.getHideOkAnn(hideProcess) == null) {
            Object[] params = new Object[] { currentProcess_ };
            reportError(new Error(ErrorMessage.HIDE_PROC_ILLEGAL, params));
        }
        
        HashSet channelNames = (HashSet) channelSet.accept(this);
        result = (ProcChanEnv) circusProcess.accept(this);
        result = result.hide(channelNames);

        // Add id annotation
        IdCircusProcessAnn ann = new IdCircusProcessAnn(
                IdCircusProcessGenerator.getGenerator().getNextId());
        Util.addIdCircusProcessAnn(hideProcess, ann);

        return result;
    }
    
    /**
     *
     */
    public Object visitProcessD(ProcessD processD) { 
        
        ProcChanEnv result;
        
        ListTerm decls = processD.getDecl();
        CircusProcess circusProcess = processD.getCircusProcess();
        
        Decl decl;
        NameType nameType;
        
        // Add the declarations as an annotation - TEMPORARY
        Util.addListTermAnn(processD, decls);
        
        if (processD instanceof ProcessIte || processD instanceof ProcessIdx) {
            // TODO: Think about the NameType in this case.
            nameType = NameType.LocalVariable; 
            
        } else if (processD instanceof ParamProcess) {
            nameType = NameType.ProcessParam;
            
        } else
            throw new InvalidSubTypeException(processD.getClass());
        
        
        // Open a new scope to declare the block of variables
        this.environment_.openScope();
        
        for (int i = 0; i < decls.size(); i++) {
            decl = (Decl) decls.get(i);
            
            // Add IdType annotation to the declaration
            Util.addNameTypeAnn(decl, nameType);
            
            // Visits the declaration
            decl.accept(this);
        }
        
        result = (ProcChanEnv) circusProcess.accept(this);
        
        // Close scope
        this.environment_.closeScope();
        
        // Add id annotation
        IdCircusProcessAnn ann = new IdCircusProcessAnn(
                IdCircusProcessGenerator.getGenerator().getNextId());
        Util.addIdCircusProcessAnn(processD, ann);
        
        return result;
    }
    
    /**
     *
     * @param process2
     * @return
     */
    public Object visitProcess2(Process2 process2) {
        
        ProcChanEnv result = null;
        
        ProcChanEnv procChanLeft = (ProcChanEnv) process2.getLeftProc().accept(this);
        ProcChanEnv procChanRight = (ProcChanEnv) process2.getRightProc().accept(this);
        
        try {
            
            result = procChanLeft.merge(procChanRight, false);
            
        } catch (MoreThanOneWriterException e) {
            Object[] params = new Object[] { 
                    currentProcess_, currentAction_ };
            reportFatalError(new Error(ErrorMessage.PAR_WRITERS, params), e);
            
        } catch (ChanUseUnificationException e) {
            Object[] params = new Object[] { 
                    currentProcess_, currentAction_ };
            reportFatalError(new Error(ErrorMessage.CHANUSE_UNIF, params), e);
            
        } catch (ChanSyncUnificationException e) {
            Object[] params = new Object[] { 
                    currentProcess_, currentAction_ };
            reportFatalError(new Error(ErrorMessage.CHANSYNC_UNIF, params), e);
            
        } catch (DifferentCardinalitiesException e) {
            Object[] params = new Object[] { 
                    currentProcess_, currentAction_ };
            reportFatalError(new Error(ErrorMessage.DIFF_CARD, params), e);

        }
        
        // Add id annotation
        IdCircusProcessAnn ann = new IdCircusProcessAnn(
                IdCircusProcessGenerator.getGenerator().getNextId());
        Util.addIdCircusProcessAnn(process2, ann);
        
        return result;
    }
    
    /**
     * Special case for parallelism
     */
    public Object visitParProcess(ParProcess parProcess) { 
        
        ProcChanEnv result = null;
        
        try {
            ProcChanEnv procChanLeft = (ProcChanEnv) parProcess.getLeftProc().accept(this);
            ProcChanEnv procChanRight = (ProcChanEnv) parProcess.getRightProc().accept(this);

            result = procChanLeft.merge(procChanRight, true);

            // Add id annotation
            IdCircusProcessAnn ann = new IdCircusProcessAnn(
                    IdCircusProcessGenerator.getGenerator().getNextId());
            Util.addIdCircusProcessAnn(parProcess, ann);
            
        } catch (MoreThanOneWriterException e) {
            Object[] params = new Object[] { 
                    currentProcess_, currentAction_ };
            reportFatalError(new Error(ErrorMessage.PAR_WRITERS, params), e);
            
        } catch (ChanUseUnificationException e) {
            Object[] params = new Object[] { 
                    currentProcess_, currentAction_ };
            reportFatalError(new Error(ErrorMessage.CHANUSE_UNIF, params), e);
            
        } catch (ChanSyncUnificationException e) {
            Object[] params = new Object[] { 
                    currentProcess_, currentAction_ };
            reportFatalError(new Error(ErrorMessage.CHANSYNC_UNIF, params), e);
            
        } catch (DifferentCardinalitiesException e) {
            Object[] params = new Object[] { 
                    currentProcess_, currentAction_ };
            reportFatalError(new Error(ErrorMessage.DIFF_CARD, params), e);
            
        }        

        return result;
    }
    
    /** **************************************************************************************************************
     * CircusAction Tree.
     * ***************************************************************************************************************
     */
   
    /**
     * 
     */
    public Object visitBasicAction(BasicAction basicAction) { 
        
        return new ProcChanEnv();
    }
    
    /**
     * 
     */
    public Object visitAction1(Action1 action1) {
        
        ProcChanEnv result;
        
        CircusAction circusAction = action1.getCircusAction();
        
        result = (ProcChanEnv) circusAction.accept(this);
        
        return result;
    }
    
    /**
     * 
     */
    public Object visitMuAction(MuAction muAction) { /* RecursiveAction */
        
        ProcChanEnv result = null;
        
        DeclName declName = muAction.getDeclName();
        CircusAction circusAction = muAction.getCircusAction();
        
        // Add annotation
        NameTypeEnv localEnvironment = this.environment_.localEnvironment();
        Util.addNameTypeEnvAnn(muAction, localEnvironment);
        
        // Open scope for what ? Declaration of DeclName possibly.
        this.environment_.openScope();
        
        result = (ProcChanEnv) circusAction.accept(this);
        
        // Close scope
        this.environment_.closeScope();
        
        return result;
    }
    
    /**
     * 
     */
    public Object visitActionD(ActionD actionD) { 
        
        ProcChanEnv result = null;
        
        ListTerm decls = actionD.getDecl();
        CircusAction circusAction = actionD.getCircusAction();
        
        NameType nameType;
        Decl decl;
        
        // Add annotation of local environment
        NameTypeEnv localEnvironment = this.environment_.localEnvironment();
        Util.addNameTypeEnvAnn(actionD, localEnvironment);
        
        if (actionD instanceof ActionIte) {
            nameType = NameType.LocalVariable; //?
            
        } else if (actionD instanceof ParamAction) {
            nameType = NameType.ActionParam;
            
        } else
            throw new InvalidSubTypeException(actionD.getClass());
        
        // Open scope
        this.environment_.openScope();
        
        for (int i = 0; i < decls.size(); i++) {
            
            decl = (Decl) decls.get(i);
            
            // Adds the annotation
            Util.addNameTypeAnn(decl, nameType);
            
            // Visits the declaration
            decl.accept(this);
            //this.environment_.declareInCurrentScope(decl, nameType);
        }
        
        result = (ProcChanEnv) circusAction.accept(this);
          
        
        // Close scope
        this.environment_.closeScope();
        
        return result;
    }
    
    /**
     * 
     */
    public Object visitGuardedAction(GuardedAction guardedAction) { 
        
        ProcChanEnv result = null;
        
        Pred pred = guardedAction.getPred();
        CircusAction circusAction = guardedAction.getCircusAction();
        
        pred.accept(this);
        result = (ProcChanEnv) circusAction.accept(this);
        
        return result;
    }
    
    /**
     * 
     */
    public Object visitAction2(Action2 action2) { 
        
        ProcChanEnv result = new ProcChanEnv();
        
        result = (ProcChanEnv) action2.getLeftAction().accept(this);
        
        try {
            result = result.merge((ProcChanEnv) action2.getRightAction().accept(this), false);
        } catch (MoreThanOneWriterException e) {
            Object[] params = new Object[] { 
                    currentProcess_, currentAction_ };
            reportFatalError(new Error(ErrorMessage.PAR_WRITERS, params), e);
            
        } catch (ChanUseUnificationException e) {
            Object[] params = new Object[] { 
                    currentProcess_, currentAction_ };
            reportFatalError(new Error(ErrorMessage.CHANUSE_UNIF, params), e);

        } catch (ChanSyncUnificationException e) {
            Object[] params = new Object[] { 
                    currentProcess_, currentAction_ };
            reportFatalError(new Error(ErrorMessage.CHANSYNC_UNIF, params), e);
            
        } catch (DifferentCardinalitiesException e) {
            Object[] params = new Object[] { 
                    currentProcess_, currentAction_ };
            reportFatalError(new Error(ErrorMessage.DIFF_CARD, params), e);

        }
        
        return result;
    }
    
    /**
     * 
     */
    public Object visitExtChoiceAction(ExtChoiceAction extChoiceAction) {
        
        // Special case. Need to classify the channels as alting channel input
        ProcChanEnv result = new ProcChanEnv();
        
        CircusAction leftAction = extChoiceAction.getLeftAction();
        CircusAction rightAction = extChoiceAction.getRightAction();
        
        List actions = Util.getActions(extChoiceAction, Constants.OP_EXTCHOICE);
        CircusAction circusAction;
        
        for (int i = 0; i < actions.size(); i++) {
            
            circusAction = (CircusAction) actions.get(i);
            
            // Sets the flag for external choice
            this.externalChoice_ = true;
            
            try {
                result = result.merge((ProcChanEnv) circusAction.accept(this), false);
                
            } catch (MoreThanOneWriterException e) {
                Object[] params = new Object[] { 
                        currentProcess_, currentAction_ };
                reportFatalError(new Error(ErrorMessage.PAR_WRITERS, params), e);

            } catch (ChanUseUnificationException e) {
                Object[] params = new Object[] { 
                        currentProcess_, currentAction_ };
                reportFatalError(new Error(ErrorMessage.CHANUSE_UNIF, params), e);

            } catch (ChanSyncUnificationException e) {
                Object[] params = new Object[] { 
                        currentProcess_, currentAction_ };
                reportFatalError(new Error(ErrorMessage.CHANSYNC_UNIF, params), e);
                
            } catch (DifferentCardinalitiesException e) {
                Object[] params = new Object[] { 
                        currentProcess_, currentAction_ };
                reportFatalError(new Error(ErrorMessage.DIFF_CARD, params), e);

            }            
                
        }
        
        return  result;
    }
    
    /**
     * 
     */
    public Object visitParAction(ParAction parAction) {
        
        ProcChanEnv result = new ProcChanEnv();
        
        // Add annotation
        NameTypeEnv localEnvironment = this.environment_.localEnvironment();
        Util.addNameTypeEnvAnn(parAction, localEnvironment);
        
        result = (ProcChanEnv) parAction.getLeftAction().accept(this);
        
        try {
            
            result = result.merge((ProcChanEnv) parAction.getRightAction().accept(this), true);
            
        } catch (MoreThanOneWriterException e) {
            Object[] params = new Object[] { 
                    currentProcess_, currentAction_ };
            reportFatalError(new Error(ErrorMessage.PAR_WRITERS, params), e);
            
        } catch (ChanUseUnificationException e) {
            Object[] params = new Object[] { 
                    currentProcess_, currentAction_ };
            reportFatalError(new Error(ErrorMessage.CHANUSE_UNIF, params), e);

        } catch (ChanSyncUnificationException e) {
            Object[] params = new Object[] { 
                    currentProcess_, currentAction_ };
            reportFatalError(new Error(ErrorMessage.CHANSYNC_UNIF, params), e);
            
        } catch (DifferentCardinalitiesException e) {
            Object[] params = new Object[] { 
                    currentProcess_, currentAction_ };
            reportFatalError(new Error(ErrorMessage.DIFF_CARD, params), e);

        }        
        
        return result;
    }
    
    /**
     * 
     */
    public Object visitCallAction(CallAction callAction) { 
        
        ProcChanEnv result = new ProcChanEnv();
        
        RefName refName = callAction.getRefName();
        CallType callType = callAction.getCallType();
        
        if (callType == CallType.Normal) {
            
            // Nothing to be done here.
            // The RefName is a reference to another action (in this same
            // process) which has already been visited or will be visited.
            
            // This name can be a name of an action or a recursive call
            // TODO: Check if this should be annotated as NameType.RecursiveName ?
            Util.addNameTypeAnn(refName, NameType.ActionName);
            
        } else if (callType == CallType.Param || 
                callType == CallType.Gen || callType == CallType.Index) {
            
            ListTerm params = callAction.getExpr();
            Expr expr;
            
            // Visit the parameters
            for (int i = 0; i < params.size(); i++) {
                
                expr = (Expr) params.get(i);
                expr.accept(this);
            }
            
            // This name can be a name of an action or a recursive call
            // TODO: Check if this should be annotated as NameType.RecursiveName ?
            Util.addNameTypeAnn(refName, NameType.ActionName);
            
        } else {
            throw new InvalidParameterException("Invalid Parameter (" + 
                    callType.getClass() + "): " + callType.toString());
        }
        
        return result;
    }
    
    /**
     * 
     */
    public Object visitPrefixingAction(PrefixingAction prefixingAction) {
        
        ProcChanEnv result = null;
        
        CircusAction circusAction = prefixingAction.getCircusAction();
        Communication communication = prefixingAction.getCommunication();
        
        ChanUse chanUse = null;
        ChanSync chanSync = null;

        // Open scope for the possible declaration of input variable
        // ATTENTION: Originally, this was done before the visitation of the fields.
        this.environment_.openScope();

        // Visits the communication
        communication.accept(this);
        
        try {
            chanUse = Util.getChanUseClassification(communication);
        
            // Finds out the classification (ChanUse and ChanSync) of communication
            if (this.externalChoice_) {
                if (chanUse.equals(ChanUse.Output)) {
                    Object[] params = new Object[] {
                        currentProcess_, currentAction_, communication.getChanName()
                    };
                    reportFatalError(new Error(ErrorMessage.OUTPUT_EXT_CHOICE, params));
                }
                chanUse = ChanUse.Input;
                this.externalChoice_ = false;
            } else {
                chanUse = Util.getChanUseClassification(communication);
            }
            chanSync = Util.getChanSyncClassification(communication);

        } catch (InvalidFormatCommException e) {
            Object[] params = new Object[] { 
                    currentProcess_, currentAction_, communication.getChanName() };
            reportFatalError(new Error(ErrorMessage.CHAN_FORMAT, params), e);
        }

        // Includes as a visible channel
        // (Gets the type of the channel in the environment)
        CircusType circusTypeChannel = this.environment_.getCircusType(
                communication.getChanName().toString());

        // Visits the action
        result = (ProcChanEnv) circusAction.accept(this);

        // Closes the scope
        this.environment_.closeScope();

        try {
            result.includeVisible(communication.getChanName().toString(), 
                    chanUse, chanSync, circusTypeChannel);
        } catch (ChanDefOtherChanUseException e) {
            // TODO
        } catch (ChanDefOtherChanSyncException e) {
            // TODO
        }

        return result;
    }
    
    /**
     * 
     */
    public Object visitCommunication(Communication communication) {
        
        // When the integration with the typechecker is done, it will
        // not be necessary to add information about circus type only
        // name type.
        
        RefName chanName = communication.getChanName();
        ListTerm chanFields = communication.getChanFields();
        ListTerm genActuals = communication.getGenActuals();
        Integer multiSych = communication.getMultiSych();
        CommType commType = communication.getCommType();
        
        Field field;
        
        // Gets the type of the channel in the environment
        CircusType circusTypeChannel = this.environment_.getCircusType(chanName.toString());

        // Visits all the fields
        for (int i = 0; i < chanFields.size(); i++) {

            field = (Field) chanFields.get(i);
            field.accept(this);
        }

        // MOVED TO PREFIXING_ACTION
        // Open scope for the possible declaration of input variable
        // this.environment_.openScope();

        field = null;
        // Gets the last parameter
        if (chanFields.size() > 0) {

            field = (Field) chanFields.get(chanFields.size()-1);

            if (field instanceof InputField) {

                RefName refName = ((InputField) field).getVariable();

                // Add a type annotation to the input variable
                CircusType circusTypeVariable = Util.getLastTypeChannel(
                        circusTypeChannel, genActuals);

                circusTypeVariable = this.environment_.declareName(
                        this.factory_.createDeclName(refName.toString()),
                        NameType.LocalVariable,
                        circusTypeVariable);

                Util.addCircusTypeAnn(refName, circusTypeVariable);
            }
        }

        return null;
    }
    
    /** **************************************************************************************************************
     * Field Tree.
     * ***************************************************************************************************************
     */
    
    /**
     * 
     */
    public Object visitInputField(InputField inputField) { 
        
        Pred restriction = inputField.getRestriction();
        RefName variable = inputField.getVariable();
        
        /**
         * Declaration of the variable will not be done here.
         *
         * Instead, it is being done in visit (PrefixingAction), since only 
         * the last input variable needs to be visited (format requirement).
         */
        // variable.addAnn(NameType.LocalVariable);
        // this.environment_.declareName(new Name(
        //      variable.getName()), NameType.LocalVariable, circusTypeChannel);
        
        if (restriction != null)
            restriction.accept(this);
        
        return null;
    }
    
    /**
     * 
     */
    public Object visitOutputField(OutputField outputField) {
        
        Expr expr = outputField.getExpression();
        
        expr.accept(this);
        
        return null;
    }
    
    /**
     * 
     */
    public Object visitDotField(DotField dotField) { 
        
        Expr expr = dotField.getExpression();
        
        expr.accept(this);
        
        return null;
    }
    
    /** **************************************************************************************************************
     * Command Tree.
     * ***************************************************************************************************************
     */
    
    /**
     *
     */
    public Object visitAssignmentCommand(AssignmentCommand assignmentCommand) { 
        
        ProcChanEnv result = new ProcChanEnv();
        
        /**
         * This is result of a change in the AST. No more assignment pairs 
         * (see Manuela's email 13/08/2005
         * - Circus.xsd e CircusTools.xsd)
         */
        //List assignmentPairs = assignmentCommand.getAssignmentPair();
        List leftVars = assignmentCommand.getLeftVars();
        List exprs = assignmentCommand.getExprs();
        
        //AssignmentPair assignPair;
        RefName refName;
        Expr expr;
        CircusType circusType;

        for (int i = 0; i < leftVars.size(); i++) {

            //assignPair = (AssignmentPair) assignmentPairs.get(i);
            refName = (RefName) leftVars.get(i); //assignPair.getLHS();
            expr = (Expr) exprs.get(i); //assignPair.getRHS();

            circusType = this.environment_.getCircusType(refName.toString());

            // Add annotation of type to the variable
            Util.addCircusTypeAnn(refName, circusType);

            // Visits the expression
            expr.accept(this);
        }

        
        return result;
    }
    
    /**
     * 
     */
    public Object visitIfGuardedCommand(IfGuardedCommand ifGuardedCommand) { 
        
        ProcChanEnv result = new ProcChanEnv();
        
        List guardedActions = ifGuardedCommand.getGuardedAction();
        
        ProcChanEnv procChanEnv = null;
        GuardedAction guardedAction;
        Pred predicate;
        Action action;
        
        for (int i = 0; i < guardedActions.size(); i++) {
            
            guardedAction = (GuardedAction) guardedActions.get(i);
            
            // Visits the guarded action
            procChanEnv = (ProcChanEnv) guardedAction.accept(this);
            
            try {
                result = result.merge(procChanEnv, false);
            } catch (MoreThanOneWriterException e) {
                Object[] params = new Object[] { 
                        currentProcess_, currentAction_ };
                reportFatalError(new Error(ErrorMessage.PAR_WRITERS, params), e);

            } catch (ChanUseUnificationException e) {
                Object[] params = new Object[] { 
                        currentProcess_, currentAction_ };
                reportFatalError(new Error(ErrorMessage.CHANUSE_UNIF, params), e);

            } catch (ChanSyncUnificationException e) {
                Object[] params = new Object[] { 
                        currentProcess_, currentAction_ };
                reportFatalError(new Error(ErrorMessage.CHANSYNC_UNIF, params), e);
                
            } catch (DifferentCardinalitiesException e) {
                Object[] params = new Object[] { 
                        currentProcess_, currentAction_ };
                reportFatalError(new Error(ErrorMessage.DIFF_CARD, params), e);

            }           
        }
        
        return result;
    }
    
    /**
     *
     */
    public Object visitVarDeclCommand(VarDeclCommand varDeclCommand) { 
        
        ProcChanEnv result = new ProcChanEnv();
        
        ListTerm decls = varDeclCommand.getDeclarations();
        CircusAction circusAction = varDeclCommand.getCircusAction();
        
        Decl decl;
        
        // Open a new scope for block of variables:
        this.environment_.openScope();
        
        for (int i = 0; i < decls.size(); i++) {
            
            decl = (Decl) decls.get(i);
            
            // Adds the annotation
            Util.addNameTypeAnn(decl, NameType.LocalVariable);
            
            // Visits
            decl.accept(this);
        }
        
        result = (ProcChanEnv) circusAction.accept(this);
        
        // Close scope
        this.environment_.closeScope();
        
        return result;
    }
    
    /** **************************************************************************************************************
     * Pred Tree.
     * ***************************************************************************************************************
     */
    
    /**
     * OK
     * @param pred
     * @return
     */
    public Object visitFact(Fact fact) { 
        return null;
    }
    
    public Object visitExprPred(ExprPred exprPred) {
        
        Expr expr = exprPred.getExpr();
        
        expr.accept(this);
        
        return null;
    }
    
    public Object visitMemPred(MemPred memPred) {
        
        Expr leftExpr = memPred.getLeftExpr();
        Expr rightExpr = memPred.getRightExpr();
        
        leftExpr.accept(this);
        rightExpr.accept(this);
        
        return null;
    }
    
    /**
     * 
     */
    public Object visitNegPred(NegPred negPred) {
        
        negPred.getPred().accept(this);
        return null;
    }
    
    /**
     * 
     */
    public Object visitPred2(Pred2 pred2) {
        
        pred2.getLeftPred().accept(this);
        pred2.getRightPred().accept(this);
        return null;
    }
    
    /** **************************************************************************************************************
     * Expr Tree.
     * ***************************************************************************************************************
     */
    
    /**
     * 
     */
    public Object  visitRefExpr(RefExpr refExpr) { 
        
        RefName refName = refExpr.getRefName();
        
        CircusType circusType = this.environment_.getCircusType(refName.toString());
        Util.addCircusTypeAnn(refName, circusType);

        // Gets the name type annotation in the environment and inserts an annotation
        NameType nameType = this.environment_.getNameType(refName.toString());
        Util.addNameTypeAnn(refName, nameType);

        return null;
    }
    
    /**
     * 
     */
    public Object visitNumExpr(NumExpr NumExpr) { 
        return null;
    }
    
    /**
     * 
     */
    public Object visitExpr2(Expr2 expr2) { 
        expr2.getLeftExpr().accept(this);
        expr2.getRightExpr().accept(this);
        return null;
    }
    
    /**
     * 
     */
    public Object visitExpr1(Expr1 expr1) {
        
        expr1.getExpr().accept(this);
        return null;
    }
    
    /**
     * 
     */
    public Object visitExpr0N(Expr0N expr0N) {
        
        ListTerm exprs = expr0N.getExpr();
        Expr expr;
        
        for (int i = 0; i < exprs.size(); i++) {
            expr = (Expr) exprs.get(i);
            expr.accept(this);
        }
        
        return null;
    }
    
    /**
     * 
     */
    public Object visitBindExpr(BindExpr bindExpr) {
        
        ListTerm/*<NameExprPair>*/ pairs = bindExpr.getNameExprPair();
        
        NameExprPair pair;
        DeclName declName;
        Expr expr;
        
        for (int i = 0; i < pairs.size(); i++) {
            pair = (NameExprPair) pairs.get(i);
            declName = pair.getName();
            expr = pair.getExpr();
            
            // TODO: annotate the name
            
            // Visits the expr
            expr.accept(this);
        }
        
        return null;
    }
    
    /**
     * 
     */
    public Object visitCondExpr(CondExpr condExpr) {
        
        Pred pred = condExpr.getPred();
        Expr leftExpr = condExpr.getLeftExpr();
        Expr rightExpr = condExpr.getRightExpr();
        
        pred.accept(this);
        leftExpr.accept(this);
        rightExpr.accept(this);
        
        return null;
    }
    
    /**
     * 
     */
    public Object visitSchExpr(SchExpr schExpr) {
        
        SchText schText = schExpr.getSchText();
        
        // TODO: Fix this gambi?
        Util.addNameTypeAnn(schText, NameType.StateComponent);
        
        // Visits the schema text
        schText.accept(this);
        
        return null;
    }
    
    /**
     *
     */
    public Object visitApplExpr(ApplExpr applExpr) { 
        
        Expr leftExpr = applExpr.getLeftExpr();
        Expr rightExpr = applExpr.getRightExpr();
        Boolean mixfix = applExpr.getMixfix();

        leftExpr.accept(this);
        rightExpr.accept(this);
        
        return null;
    }
    
    /** **************************************************************************************************************
     * Util methods
     * ***************************************************************************************************************
     */
        
    /**
     * Declare all the names in the signature in the current scope.
     */
    public void defineSignature(Signature signature, NameType nameType) {
        
        DeclName variable;
        CircusType circusType;
        DeclName declName;
        NameTypePair nameTypePair;
        
        List nameTypePairs = signature.getNameTypePair();
        
        for (int i = 0; i < nameTypePairs.size(); i++) {
         
            nameTypePair = (NameTypePair) nameTypePairs.get(i);
            declName = nameTypePair.getName();
            circusType = (CircusType) nameTypePair.getType();
            
            this.environment_.declareName(declName, nameType, circusType);
        }
        
    }
    
    /**
     * Declare in the environment some definitions of the mathematical toolkit.
     */
    public void loadMathToolkit() {
        
        // \nat
        this.environment_.declareName(
                this.factory_.createDeclName(MathToolkitConstants.NAT), 
                NameType.GlobalConstant, 
                CircusType.createCircusInteger(), 
                true); //addToTypeList
        
        this.environment_.declareName(
                this.factory_.createDeclName(MathToolkitConstants.ADD), 
                NameType.GlobalConstant, 
                CircusType.createCircusInteger());

        this.environment_.declareName(
                this.factory_.createDeclName(MathToolkitConstants.SUB), 
                NameType.GlobalConstant, 
                CircusType.createCircusInteger());

        this.environment_.declareName(
                this.factory_.createDeclName(MathToolkitConstants.MULT), 
                NameType.GlobalConstant, 
                CircusType.createCircusInteger());

        this.environment_.declareName(
                this.factory_.createDeclName(MathToolkitConstants.DIV), 
                NameType.GlobalConstant, 
                CircusType.createCircusInteger());

        this.environment_.declareName(
                this.factory_.createDeclName(MathToolkitConstants.MOD), 
                NameType.GlobalConstant, 
                CircusType.createCircusInteger());
        
        this.environment_.declareName(
                this.factory_.createDeclName(MathToolkitConstants.LESS_EQUAL), 
                NameType.GlobalConstant, 
                CircusType.createCircusInteger());

        this.environment_.declareName(
                this.factory_.createDeclName(MathToolkitConstants.GREATER_EQUAL), 
                NameType.GlobalConstant, 
                CircusType.createCircusInteger());
        
        this.environment_.declareName(
                this.factory_.createDeclName(MathToolkitConstants.LESS), 
                NameType.GlobalConstant, 
                CircusType.createCircusInteger());
        
        this.environment_.declareName(
                this.factory_.createDeclName(MathToolkitConstants.GREATER), 
                NameType.GlobalConstant, 
                CircusType.createCircusInteger());
        
        this.environment_.declareName(
                this.factory_.createDeclName(MathToolkitConstants.NOTEQUAL), 
                NameType.GlobalConstant, 
                CircusType.createCircusInteger());
        
        this.environment_.declareName(
                this.factory_.createDeclName(MathToolkitConstants.NUM_RANGE), 
                NameType.GlobalConstant, 
                CircusType.createCircusInteger());
        
        this.environment_.declareName(
                this.factory_.createDeclName(MathToolkitConstants.PFUNCTION), 
                NameType.GlobalConstant, 
                CircusType.createCircusInteger());

        this.environment_.declareName(
                this.factory_.createDeclName(MathToolkitConstants.PINJECTION), 
                NameType.GlobalConstant, 
                CircusType.createCircusInteger());

        this.environment_.declareName(
                this.factory_.createDeclName(MathToolkitConstants.EMPTYSET), 
                NameType.GlobalConstant, 
                CircusType.createCircusInteger());

        this.environment_.declareName(
                this.factory_.createDeclName(MathToolkitConstants.UNION), 
                NameType.GlobalConstant, 
                CircusType.createCircusInteger());

        this.environment_.declareName(
                this.factory_.createDeclName(MathToolkitConstants.CARDINALITY), 
                NameType.GlobalConstant, 
                CircusType.createCircusInteger());

        this.environment_.declareName(
                this.factory_.createDeclName(MathToolkitConstants.SUBSETEQ), 
                NameType.GlobalConstant, 
                CircusType.createCircusInteger());

        this.environment_.declareName(
                this.factory_.createDeclName(MathToolkitConstants.SET_DIFF), 
                NameType.GlobalConstant, 
                CircusType.createCircusInteger());
    }
        
}
